// topo.java
// demonstracja sortowania topologicznego
// aby uruchomi program: C:>java TopoApp (wersja angielska)
// aby skompilowa wersj polsk: C:>javac top.java
// po kompilacji:         C:>java TopoApp
////////////////////////////////////////////////////////////////
class Vertex
   {
   public char label;        // etykieta (np. 'A')
// -------------------------------------------------------------
   public Vertex(char lab)   // konstruktor
      { label = lab; }
   }  // end class Vertex
////////////////////////////////////////////////////////////////
class Graph
   {
   private final int MAX_VERTS = 20;
   private Vertex vertexList[]; // lista wierzchokw
   private int adjMat[][];      // matryca przylegania
   private int nVerts;          // bieca liczba wierzchokw
   private char sortedArray[];
// -------------------------------------------------------------
   public Graph()               // konstruktor
      {
      vertexList = new Vertex[MAX_VERTS];
                                          // matryca przylegania
      adjMat = new int[MAX_VERTS][MAX_VERTS];
      nVerts = 0;
      for(int j=0; j<MAX_VERTS; j++)      // zerowanie matrycy
         for(int k=0; k<MAX_VERTS; k++)   //    przylegania
            adjMat[j][k] = 0;
      sortedArray = new char[MAX_VERTS];  // posortowane etykiety wierzchokw
      }  // end constructor
// -------------------------------------------------------------
   public void addVertex(char lab)
      {
      vertexList[nVerts++] = new Vertex(lab);
      }
// -------------------------------------------------------------
   public void addEdge(int start, int end)
      {
      adjMat[start][end] = 1;
      }
// -------------------------------------------------------------
   public void displayVertex(int v)
      {
      System.out.print(vertexList[v].label);
      }
// -------------------------------------------------------------
   public void topo()  // sortowanie topologiczne
      {
      int orig_nVerts = nVerts;  // zapamitaj liczb wierzchokw

      while(nVerts > 0)  // dopki s wierzchoki,
         {
         // pobierz wierzchoek bez nastpnikw lub -1
         int currentVertex = noSuccessors();
         if(currentVertex == -1)       // istnieje cykl
            {
            System.out.println("BD: W grafie znaleziono cykl");
            return;
            }
         // wstaw etykiet wierzchoka do tablicy posortowanej (zaczynamy od koca)
         sortedArray[nVerts-1] = vertexList[currentVertex].label;

         deleteVertex(currentVertex);  // usu wierzchoek
         }  // end while

      // nie ma ju wierzchokw; wywietl tablic posortowan
      System.out.print("Wierzchoki posortowane topologicznie: ");
      for(int j=0; j<orig_nVerts; j++)
         System.out.print( sortedArray[j] );
      System.out.println("");
      }  // end topo
// -------------------------------------------------------------
   public int noSuccessors()  // zwraca wierzchoek bez nastpnikw
      {                       // (lub -1, jeeli nie ma takich wierzchokw)
      boolean isEdge; // krawd midzy wierzchokiem w wierszu i wierzchokiem w kolumnie tablicy przylegania

      for(int row=0; row<nVerts; row++)  // dla kadego wierzchoka,
         {
         isEdge = false;                 // sprawd krawdzie
         for(int col=0; col<nVerts; col++)
            {
            if( adjMat[row][col] > 0 )   // jeeli jest krawd
               {                         // czca z innym wierzchokiem,
               isEdge = true;
               break;                    // ten wierzchoek
               }                         //    ma nastpnika
            }                            //    sprawd nastpny
         if( !isEdge )                   // jeeli nie ma krawdzi,
            return row;                  //    nie ma nastpnikw
         }
      return -1;                         // nie ma takiego wierzchoka
      }  // end noSuccessors()
// -------------------------------------------------------------
   public void deleteVertex(int delVert)
      {
      if(delVert != nVerts-1)      // jeeli nie jest ostatnim wierzchokiem,
         {                         // usu z listy wierzchokw
         for(int j=delVert; j<nVerts-1; j++)
            vertexList[j] = vertexList[j+1];
                                   // usu wiersz z matrycy przylegania
         for(int row=delVert; row<nVerts-1; row++)
            moveRowUp(row, nVerts);
                                   // usu kolumn z matrycy przylegania
         for(int col=delVert; col<nVerts-1; col++)
            moveColLeft(col, nVerts-1);
         }
      nVerts--;                    // jeden wierzchoek mniej
      }  // end deleteVertex
// -------------------------------------------------------------
   private void moveRowUp(int row, int length)
      {
      for(int col=0; col<length; col++)
         adjMat[row][col] = adjMat[row+1][col];
      }
// -------------------------------------------------------------
   private void moveColLeft(int col, int length)
      {
      for(int row=0; row<length; row++)
         adjMat[row][col] = adjMat[row][col+1];
      }
// -------------------------------------------------------------
   }  // end class Graph
////////////////////////////////////////////////////////////////
class TopoApp
   {
   public static void main(String[] args)
      {
      Graph theGraph = new Graph();
      theGraph.addVertex('A');    // 0
      theGraph.addVertex('B');    // 1
      theGraph.addVertex('C');    // 2
      theGraph.addVertex('D');    // 3
      theGraph.addVertex('E');    // 4
      theGraph.addVertex('F');    // 5
      theGraph.addVertex('G');    // 6
      theGraph.addVertex('H');    // 7

      theGraph.addEdge(0, 3);     // AD
      theGraph.addEdge(0, 4);     // AE
      theGraph.addEdge(1, 4);     // BE
      theGraph.addEdge(2, 5);     // CF
      theGraph.addEdge(3, 6);     // DG
      theGraph.addEdge(4, 6);     // EG
      theGraph.addEdge(5, 7);     // FH
      theGraph.addEdge(6, 7);     // GH

      theGraph.topo();            // posortuj
      }  // end main()
   }  // end class TopoApp
////////////////////////////////////////////////////////////////

